-- This procedure reports a message in the Sybase errorlog when a
-- threshold on the logsegment is crossed and this procedure is
-- associated with it (use sp_addthreshold to do this).
-- Installed into sybsystemprocs so it is accessible from all databases
--
-- May be copied and redistributed freely with the inclusion of this:
-- Written by Peter Sap (www.petersap.nl)

use     sybsystemprocs
go

if      object_id("sp_tranlogusage") != null
        drop    proc sp_tranlogusage
go

create	proc	sp_tranlogusage	@dbname		varchar(30),
				@segmentname	varchar(30),
				@space_left	int,
				@status		int
as

declare	@size	int,
	@perc	tinyint

if	@segmentname	!= "logsegment"
	return	0

-- calculate the total size in pages of the logsegment for a database
select	@size	= sum(size)
	from	master..sysusages
	where	dbid		= db_id(@dbname)
	and	segmap & 4	= 4 -- logsegment

-- calculate the percentage of free space
select	@perc	= round((@space_left / convert(float,@size)) * 100,0)

-- when some portion of the logsegment is shared with another segment
-- we are not sure of the actual percentage
if	exists(
	select	1
		from	master..sysusages
		where	dbid		= db_id(@dbname)
		and	segmap & 4	= 4 -- logsegment
		and	segmap		!= 4) -- in use by other segments?
	print	"** Space for the transactionlog in database %1! dropped below %2! percent **",
		@dbname,
		@perc
else
	print   "** Transactionlog for database %1! %2! percent free **",
        	@dbname,
        	@perc

return  0
go

-- grant the stored procedure to public (threshold procedures are executed
-- under dbo)
grant   execute on sp_tranlogusage
        to public
go
